function Component()
{
    // default constructor
    if (systemInfo.productType === "windows") {
			var doInstall = false;
		if(installer.value("prog_x86",false)=="true") {//x86
			var registryVC2019x86 = installer.execute("reg", new Array("QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x86", "/v", "Installed"))[0];
			if (!registryVC2019x86) {
				doInstall = true;
			} else	{
				var bld = installer.execute("reg", new Array("QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x86", "/v", "Bld"))[0];

				var elements = bld.split(" ");

				bld = parseInt(elements[elements.length-1]);
				if (bld < 30139)
				{
					doInstall = true;
				}
			}
		} else {//x64
			var registryVC2019x64 = installer.execute("reg", new Array("QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64", "/v", "Installed"))[0];
			if (!registryVC2019x64) {
				doInstall = true;
			}
			else
			{
				var bld = installer.execute("reg", new Array("QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64", "/v", "Bld"))[0];

				var elements = bld.split(" ");

				bld = parseInt(elements[elements.length-1]);
				if (bld < 30139)
				{
					doInstall = true;
				}
			}
		}
		if (!doInstall){
			component.setValue("Default",false);
			component.setValue("Description","Компонент уже установлен");
			component.setValue("ForcedInstallation",false);
			component.enabled = false;
		}
    }
}

Component.prototype.createOperations = function()
{
    // call default implementation to actually install README.txt!
    component.createOperations();
	var redistx86_file = installer.toNativeSeparators(installer.value("TargetDir")+"/vcredist_x86.exe");
	var redistx64_file = installer.toNativeSeparators(installer.value("TargetDir")+"/vcredist_x64.exe");
	var redist_file = installer.value("prog_x86",false)=="true" ? redistx86_file : redistx64_file;
    if (component.enabled)
		component.addOperation("Execute",redist_file,"/norestart", "/passive");
	component.addOperation("Delete",redist_file);
}
