
function Component() {
    if (installer.isInstaller()) {
		installer.installationStarted.connect(this, Component.prototype.installationStarted);
		component.valueChanged.connect(this,Component.prototype.valueChanged);
	}
}

Component.prototype.valueChanged = function(key,val){
	if (key=="UncompressedSizeSum"){
		var grd_drivers=installer.components("com.guradant.drivers")[0];
		if (val == "0"){
			installer.removeWizardPage(component, "LicenseWidget", QInstaller.ReadyForInstallation);
			grd_drivers.setValue("Default",false);
			installer.deselectComponent(grd_drivers.name);
		}
		else {
			grd_drivers.setValue("Default",true);
			installer.selectComponent(grd_drivers.name);
			if (installer.addWizardPage(component, "LicenseWidget", QInstaller.ReadyForInstallation)) {
				var widget = gui.pageWidgetByObjectName("DynamicLicenseWidget");
				if (widget != null) {
					widget.selectLicenseFile.clicked.connect(this, Component.prototype.selectLicenseFile);
				}		
			}
		}
	}
}

Component.prototype.selectLicenseFile = function() {
    var widget = gui.pageWidgetByObjectName("DynamicLicenseWidget");
    if (widget != null) {
        var licFile = QFileDialog.getOpenFileName("Выберите файл лицензии", "", "Файлы лицензий (*.license *.xml);;Все файлы (*.*)");
        if (licFile != "")
            widget.licenseFile.text = licFile;
    }
}

Component.prototype.installationStarted = function() {
    var widget = gui.pageWidgetByObjectName("DynamicLicenseWidget");
	if (widget == null)
		return;
	component.addOperation("Replace","@TargetDir@\\RoadLicenseSrv.ini","path=arm2.license","path="+widget.licenseFile.text);
	if (widget.port.value != 15555)
		component.addOperation("Replace","@TargetDir@\\RoadLicenseSrv.ini","serverPort=15555","serverPort="+widget.port.value);
	if (widget.web_port.value != 8080)
		component.addOperation("Replace","@TargetDir@\\RoadLicenseSrv.ini","serverPort=8080","serverPort="+widget.web_port.value);
	if (!widget.listenLocal.checked)
		component.addOperation("Replace","@TargetDir@\\RoadLicenseSrv.ini","127.0.0.1","0.0.0.0");
	component.addOperation("Execute","@TargetDir@\\roadlicense.exe","-i","UNDOEXECUTE","sc","stop","Ripas License Server");
	component.addOperation("Execute","sc","config","Ripas License Server","start=","auto","UNDOEXECUTE","sc","delete","Ripas License Server");
	component.addOperation("Execute","sc","start","Ripas License Server");
}
