function Component()
{
	if (installer.isInstaller()){
		var reg_key;
		if(installer.value("prog_x86",false)=="true")
			reg_key = "HKEY_CURRENT_USER\\Software\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{c0f1e976-f585-48f8-968d-48c870496d4e}";
		else
			reg_key = "HKEY_CURRENT_USER\\Software\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{0f40e78b-67e1-4e0c-a2fd-e9325d9dfc82}";
		var py_installed = installer.execute("reg", new Array("QUERY", reg_key, "/v", "Installed"))[0];
		if (py_installed){
			var elements = py_installed.split(" ");
			if (parseInt(elements[elements.length-1]) == 1) {
				component.setValue("Default",false);
				component.setValue("ForcedInstallation",false);
				component.setValue("Description","Программа уже установлена");
				component.enabled = false;
			}
		}
	}
}

Component.prototype.createOperations = function()
{
    // call default implementation to actually install the registeredfile
    component.createOperations();
	var inst_file;
    if(installer.value("prog_x86",false)=="true") {
    //x86
		inst_file = "python-3.7.2.exe";
	} else {
		inst_file = "python-3.7.2-amd64.exe";
	}
    var native_path=installer.toNativeSeparators(installer.value("TargetDir")+"/"+inst_file);
    if (component.enabled)
        component.addOperation("Execute",native_path, "/passive");
    component.addOperation("Delete",native_path);
}
