# -*- coding: utf-8 -*-
"""
Модуль "Камеры":
Панель инструментов Камеры
Обработчики событий

(c)2013 ЗАО "РИПАС" и Демин Федор,
www.ripas.ru dff@ripas.ru
"""
from RoadCentre import plugins

def actionCam(act):
	if hasattr(plugins,'CamLayerPlugin'): plugins.CamLayerPlugin.setTypeVisible(act.data(),act.checked)

def actionCamArea():
	if hasattr(plugins,'CamLayerPlugin'): plugins.CamLayerPlugin.viewAreaAlwaysVisible = not plugins.CamLayerPlugin.viewAreaAlwaysVisible

def getCamlistFile():
	from PythonQt import QtCore
	from RoadCentre import project
	cam_file=QtCore.QDir(project.baseDir).filePath("vlc_cams.xml")
	del QtCore,project
	return cam_file

def loadCamList():
	if not hasattr(plugins,'CamLayerPlugin'):
		return
	from RoadCentre import kernel
	plugins.CamLayerPlugin.loadVlcCamList(getCamlistFile(),kernel.graphicsScene.addLayer(u'Камеры'))
	kernel.itemModel.addObjects(u'Камеры',plugins.CamLayerPlugin.children())
	del kernel

def saveCamList():
	if not hasattr(plugins,'CamLayerPlugin'):
		return
	from RoadCentre import project
	plugins.CamLayerPlugin.saveVlcCamList(getCamlistFile())
	del project

from menu import SubMenu
class SceneCameraMenu(SubMenu):
	def __init__(self):
		SubMenu.__init__(self, (u'Камера на сцене', u'Камеры на сцене'))
		a = self.menuMain.addAction(u'Удалить')
		a.connect('triggered()', self.deleteCam)

	def deleteCam(self):
		for o in self.selection:
			if not o.inherits("SceneCamProxyWidget"):
				continue
			o.close()

class CameraMenu(SubMenu):
	def __init__(self):
		SubMenu.__init__(self, (u'Камера', u'Камеры'))
		a = self.menuMain.addAction(u'Показать')
		a.connect('triggered()', self.play)
		a = self.menuMain.addAction(u'Показать на сцене')
		a.connect('triggered()', self.playOnScene)
		self.playImagesAction = self.menuMain.addAction(u'Показать изображения')
		self.playImagesAction.connect('triggered()', self.playImages)
		self.playImagesAction.enabled=False
		self.playImagesAction2 = self.menuMain.addAction(u'Показать изображения на сцене')
		self.playImagesAction2.connect('triggered()', self.playImagesOnScene)
		self.playImagesAction2.enabled=False
		self.menuMain.addSeparator()
		a = self.menuMain.addAction(u'Удалить')
		a.connect('triggered()', self.deleteCams)
		a = self.menuMain.addAction(u'Свойства')
		a.connect('triggered()', self.editCamProperties)

	def play(self):
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			o.play()

	def playOnScene(self):
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			o.play(False,True)

	def playImages(self):
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			if o.hasImages:
				o.play(True)

	def playImagesOnScene(self):
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			if o.hasImages:
				o.play(True,True)

	def deleteCams(self):
		from PythonQt import QtGui
		from gui import mainWindow
		if QtGui.QMessageBox.question(mainWindow,u'Вопрос',u'Удалить выбранные камеры?',QtGui.QMessageBox.Yes|QtGui.QMessageBox.No)!=QtGui.QMessageBox.Yes:
			return
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			plugins.CamLayerPlugin.deleteCamera(o)
		saveCamList()

	def editCamProperties(self):
		for o in self.selection:
			if not o.inherits("CamGraphicsItem"):
				continue
			if plugins.CamLayerPlugin.editCamProperties(o):
				from PythonQt import QtCore
				from RoadCentre import project
				plugins.CamLayerPlugin.saveVlcCamList(QtCore.QDir(project.baseDir).filePath("vlc_cams.xml"))
				del QtCore,project
			break

	def menu(self, obj):
		count = len(obj)
		if not count: return None
		if count == 1:
			self.playImagesAction.enabled=obj[0].hasImages
			self.playImagesAction2.enabled=obj[0].hasImages
		else:
			self.playImagesAction.enabled=False
			self.playImagesAction2.enabled=False
			for o in obj:
				if o.hasImages:
					self.playImagesAction.enabled=True
					self.playImagesAction2.enabled=True
					break
		return SubMenu.menu(self, obj)

