# -*- coding: utf-8 -*-
"""
Инициализация модуля "Камеры":
Панель инструментов Камеры
Обработчики событий

(c)2012 - 2013 ЗАО "РИПАС" и Демин Федор,
www.ripas.ru dff@ripas.ru
"""
from RoadCentre import plugins
from gui import mainWindow, msgOk
from PythonQt import Qt,QtGui

if hasattr(plugins,'CamLayerPlugin'):
    import cams, menu, settings
    menu.Menu.devClassMenus['CamGraphicsItem']=cams.CameraMenu()
    menu.Menu.devClassMenus['SceneCamProxyWidget']=cams.SceneCameraMenu()

    tb=mainWindow.addToolBar(u'Камеры')
    tb.objectName='toolBarCams'
    agr = Qt.QActionGroup(tb)
    action=agr.addAction(u'Камеры')
    action.checkable=1
    action.setData(1)
    action.icon=QtGui.QIcon(':resources/camera.png')
    #action.statusTip = action.toolTip = u'Отобразить'
    action=agr.addAction(u'Фиксаторы номеров')
    action.checkable=1
    action.setData(2)
    action.icon=QtGui.QIcon(':resources/camera_2.png')
    #action.statusTip = action.toolTip = u'Отобразить'
    action=agr.addAction(u'Видеодетекторы')
    action.checkable=1
    action.setData(3)
    action.icon=QtGui.QIcon(':resources/camera_3.png')
    #action.statusTip = action.toolTip = u'Отобразить'
    tb.addActions(agr.actions())
    agr.setExclusive(0)
    agr.connect('triggered(QAction*)', cams.actionCam)

    tb.addSeparator()
    action=tb.addAction(u'Обзор')
    action.connect('triggered()', cams.actionCamArea)
    action.statusTip = action.toolTip = u'Скрыть/показать сектора обзора камер'

    sceneCamZoomSizes=settings.array('sceneCamZoomSizes','Plugins/CamLayerPlugin')
    if sceneCamZoomSizes==None:
        plugins.CamLayerPlugin.setSceneCamZoomSize(12,88,72)
        plugins.CamLayerPlugin.setSceneCamZoomSize(14,176,144)
        plugins.CamLayerPlugin.setSceneCamZoomSize(15,352,288)
    else:
        for row in sceneCamZoomSizes:
            plugins.CamLayerPlugin.setSceneCamZoomSize(int(row['zoom']),int(row['width']),int(row['height']))

    msgOk(u'Инициализации модуля "Камеры" выполнена')
