        # -*- coding: utf-8 -*-
"""
Запуск системы приоритетного пропуска

(c)2016 ЗАО "РИПАС"
www.ripas.ru
"""
from PythonQt import QtGui
from gui import msgError,mainWindow
from RoadCentre import plugins
import RoadCentre
from settings import userSettings

try:
    from priority import PriorityClient
    control_connection=RoadCentre.project.settings.value('Priority/ControlServer')
    if control_connection and int(userSettings.value('Priority/Enabled', 1)) != 1:
        control_connection = None
    if not control_connection:
        vdt_connection=RoadCentre.project.settings.value('Priority/VdtServer')
        if vdt_connection:
            from PythonQt import QtNetwork
            import json
            sock=QtNetwork.QTcpSocket()
            host,port=vdt_connection.split(':')
            sock.connectToHost(host,int(port))
            if sock.waitForConnected(500):
                sock.write('{"jsonrpc": "2.0","method":"upgrade","id":1}\n')
                if sock.waitForReadyRead(500):
                    j_ans=json.loads(sock.readAll().data())
                    port=j_ans.get("result")
                    if port:
                        control_connection=host+':'+str(port)
                        RoadCentre.project.settings.setValue('Priority/ControlServer',control_connection)
                        RoadCentre.project.settings.remove('Priority/VdtServer')
                        RoadCentre.project.settings.remove('Priority/BoardsServer')
    if hasattr(RoadCentre,'priority'):
        RoadCentre.priority.stop()
        RoadCentre.priority.deleteLater()
        del RoadCentre.priority
    if control_connection:
        RoadCentre.priority=PriorityClient(control_connection.split(':'))
        RoadCentre.project.connection.connect('stateChanged(const Spectr::Connection::State)', RoadCentre.priority.on_project_connectionStateChanged)
except:
    msgError(u'Ошибка при запуске модуля "Приоритетный пропуск"')
    raise
