# -*- coding: utf-8 -*-
"""
Отображение таблицы с показателями здоровья детекторов за последие 24 часа
(c)2013 ЗАО "РИПАС"
www.ripas.ru
"""

from RoadCentre import plugins,kernel
from PythonQt import QtGui,QtCore,private
import dthealth
from gui import msgError
if hasattr(QtCore, 'QObject'):
    from PythonQt.QtCore import QObject
elif hasattr(private, 'QObject'):
    QObject = private.QObject
try:
    from objfilter import add_filter,remove_filter,set_filter_checked
    has_obj_filter = True
except ModuleNotFoundError:
    has_obj_filter = False

class HealthTable:
    FILTER_TABLE = None
    def __init__(self):
        import gui
        self.healthWnd=gui.widgetFromUi('dthealth/health.ui')
        self.healthWnd.setParent(gui.mainWindow)
        self.stackedWidget=self.healthWnd.findChild('QStackedWidget','stackedWidget')
        self.table=self.healthWnd.findChild('QTableWidget','healthTable')
        self.table.connect('itemSelectionChanged()',self.tableSelectionChanged)
        self.table.connect('cellDoubleClicked(int,int)',self.tableCellDoubleClicked)

        self.statusLabel=self.healthWnd.findChild('QLabel','status')
        self.matches=self.healthWnd.findChild('QLabel','matches')
        self.progressBar=self.healthWnd.findChild('QProgressBar','progressBar')

        threshold=self.healthWnd.findChild('QCheckBox','threshold')
        threshold.connect('clicked(bool)',self.threshold_on_off)

        self.filterObjectsOnMap = self.healthWnd.findChild('QCheckBox','filterObjectsOnMap')
        if not has_obj_filter or HealthTable.FILTER_TABLE:
            self.filterObjectsOnMap.visible = False
        else:
            self.filterObjectsOnMap.connect('clicked(bool)',self.filter_on_map_on_off)
            HealthTable.FILTER_TABLE = self
        
        self.healthThreshold=self.healthWnd.findChild('QSpinBox','healthThreshold')
        self.healthThreshold.connect('valueChanged(int)',self.threshold_changed)
        self._update_filter_name(self.healthThreshold.value)

        save=self.healthWnd.findChild('QPushButton','save')
        save.connect('clicked()',self.save_all)

        if not hasattr(self,'wndTitle'):
            self.wndTitle=u'Здоровье детекторов'

        self.stackedWidget.currentIndex=0

        self.pkernel=PseudoKernel()
        from menu import Menu
        Menu(self.pkernel).setWidgetContextMenu(self.table);
        if hasattr(plugins,'RoadNetworkPlugin'):
            Menu.devClassMenus['DtHealth::NoNetworkDetector']=Menu.devClassMenus['Road::Graphics::DetectorItem']
        elif hasattr(plugins,'Net329gPlugin'):
            from net329 import DetectorMenu
            Menu.devClassMenus['DtHealth::NoNetworkDetector']=Menu.devClassMenus.get('QGraphicsItem%d'%65540,DetectorMenu())
        del gui
        self.dtinfo={}
        self.visible_objects = set()
    
    def __del__(self):
        if HealthTable.FILTER_TABLE == self:
            HealthTable.FILTER_TABLE = None

    def show(self):
        import gui
        doc = QtGui.QDockWidget(self.wndTitle)
        del self.wndTitle
        doc.setAttribute(QtCore.Qt.WA_DeleteOnClose)
        doc.objectName='dthealthwnd'
        doc.setWidget(self.healthWnd)
        doc.destroyed.connect(self._on_window_destroyed)
        gui.mainWindow.addDockWidget(QtCore.Qt.LeftDockWidgetArea, doc)
        if not gui.mainWindow.restoreDockWidget(doc):
            doc.floating=True
        doc.show()
        getattr(doc, 'raise')()
        del gui

        adb=plugins.RcdViewPlugin.database()
        if adb:
            obj_list_cond=''
            from RoadCentre import project
            visible_obj = [o.id for o in project.objects() if o.graphicsItem.isVisible()]
            if hasattr(self,'objects'):
                self.objects = [o for o in self.objects if o in visible_obj]
            else:
                self.objects = visible_obj
            from RoadCentre import project
            visible_obj = [o.id for o in project.objects() if o.graphicsItem.isVisible()]
            self.objects = [o for o in self.objects if o in visible_obj]
            if len(self.objects)==0:
                self.on_query_error(u'В выбранном контейнере нет объектов')
                return
            obj_list_cond='objectid in ('
            for oid in self.objects:
                obj_list_cond+='%d,'%oid
            obj_list_cond=obj_list_cond[:-1]+') and'

            stop=QtCore.QDateTime.currentDateTime()
            start=stop.addDays(-1)

            #Получаем имена объектов и кое-какие флаги детекторов
            where_cond=''
            if obj_list_cond!='':
                where_cond='where detectors.'+obj_list_cond[:-4]
            query_text="""
            SELECT
              detectors.objectId,
              detectors.id,
              objects.name,
              detectors.collect,
              detectors.useGlobalParam,
              detectors.lastCorrection
            FROM detectors
              INNER JOIN objects
                ON detectors.objectId = objects.id
            %s"""%where_cond

            query=adb.newQuery(query_text,True)
            query.connect('finished(QVariantList)',self.on_query1_finished)
            query.connect('error(QString)',self.on_query_error)
            adb.execQuery(query)

            #Получаем список здоровья для всех дт за последние 24 часа
            query_text="""
            SELECT
              objectId,
              detectorId,
              cnt / 96 * 100,
              state AS sick
            FROM (SELECT
                objectId,
                detectorId,
                state>0 as state,
                COUNT(*) AS cnt
              FROM dt15
              WHERE time BETWEEN '%s' AND '%s'
              GROUP BY objectId,
                       detectorId,
                       state>0) AS tt
            WHERE %s
            GROUP BY objectId,
                     detectorId,
                     cnt,
                     state""" % (
                     start.toString('yyyy-MM-dd hh:mm'),stop.toString('yyyy-MM-dd hh:mm'),
                     obj_list_cond[:-4]
                     )
            query=adb.newQuery(query_text,True)
            query.connect('finished(QVariantList)',self.on_query_finished)
            query.connect('error(QString)',self.on_query_error)
            adb.execQuery(query)

    def on_query1_finished(self,result):
        self.dtinfo={}
        for data in result:
            obj_id=data[0]
            dt_id=data[1]
            if obj_id not in self.dtinfo:
                self.dtinfo[obj_id]={}
            dt_dict = self.dtinfo[obj_id]
            if dt_id not in dt_dict:
                dt_dict[dt_id]={}
            dt_param = dt_dict[dt_id]
            dt_param['name'] = data[2]
            dt_param['collect'] = data[3]
            dt_param['use_global'] = data[4]
            dt_param['last_correction'] = data[5]
            dt_param['processed'] = False

    def on_query_finished(self,result):
        self.table.sortingEnabled=False
        self.NoNetworkDetectors={}
        for data in result:
            row=self.table.rowCount
            obj_id=data[0]
            dt_id=data[1]
            dt_param={}
            if obj_id in self.dtinfo:
                dt_param=self.dtinfo[obj_id][dt_id]
            has_dt_param=(len(dt_param)>3)
            if has_dt_param and not dt_param['collect']:
                continue
            if dt_param['processed']:
                continue
            dt_param['processed'] = True	# пометим как уже внесенный в таблицу и не требующий дальнейшей отдельной обработки
            self.table.insertRow(row)
            is_sick=(data[3]!=0)
            for col in range(3):
                val=data[col]
                if val==None:
                    continue
                if col==2:
                    if is_sick:
                        val=100-val
                    val=int(val)
                self.newTableItem(row,col).setData(QtCore.Qt.DisplayRole,val)
                if col==0:
                    obj_id=val
                if col==1:
                    self.NoNetworkDetectors['%d-%d'%(obj_id,val)]=NoNetworkDetector(obj_id,val)
            if has_dt_param:
                self.newTableItem(row,3).setData(QtCore.Qt.DisplayRole,dt_param['name'])
                self.newTableItem(row,4).setData(QtCore.Qt.DisplayRole,dt_param['use_global'])
                self.newTableItem(row,5).setData(QtCore.Qt.DisplayRole,dt_param['last_correction'])
        for objid in self.dtinfo:
            for det in self.dtinfo[objid]:
                row=self.table.rowCount
                dt_param = self.dtinfo[objid][det] 
                if dt_param['collect'] and dt_param['processed']==False:	# канал значится как собираемый, но нет данных о здоровье
                    self.table.insertRow(row)
                    no_data = "нет данных"
                    self.newTableItem(row,0).setData(QtCore.Qt.DisplayRole,objid)   # ObjID
                    self.newTableItem(row,1).setData(QtCore.Qt.DisplayRole,det)     # DetID
                    self.newTableItem(row,2).setData(QtCore.Qt.DisplayRole,no_data)
                    self.newTableItem(row,3).setData(QtCore.Qt.DisplayRole,self.dtinfo[objid][det]['name'])  # ObjName
                    self.newTableItem(row,4).setData(QtCore.Qt.DisplayRole,no_data)
                    self.newTableItem(row,5).setData(QtCore.Qt.DisplayRole,no_data)

        self.table.sortingEnabled=True
        self.stackedWidget.currentIndex=1

    def newTableItem(self,row,col):
        self.table.setItem(row,col,QtGui.QTableWidgetItem().clone())
        return self.table.item(row,col)

    def on_query_error(self,msg):
        self.stackedWidget.currentIndex=0
        self.statusLabel.text=msg
        self.progressBar.visible=False

    def getTableValue(self,row,col):
        item=self.table.item(row,col)
        if not item:
            return None
        return item.data(QtCore.Qt.DisplayRole)

    def threshold_on_off(self,on):
        if HealthTable.FILTER_TABLE == self:
            self.filterObjectsOnMap.enabled = on
        if on:
            self.threshold_changed(self.healthThreshold.value)
        else:
            for row in range(self.table.rowCount):
                self.table.setRowHidden(row,False)
            self.visible_objects = set()
            if self.filterObjectsOnMap.visible:
                self.filterObjectsOnMap.checked = False

    def filter_on_map_on_off(self,on):
        if on:
            self._update_filter_name(self.healthThreshold.value)
            add_filter(self.filter_name,self._filter_obj_checker)
            set_filter_checked(self.filter_name,False)
        else:
            remove_filter(self.filter_name)

    def _filter_obj_checker(self,obj):
        return obj.id in self.visible_objects and obj.id in self.dtinfo

    def _update_filter_name(self,th_val):
        self.filter_name = "Со здоровьем дт>=%d или без дт" % th_val

    def _on_window_destroyed(self):
        if HealthTable.FILTER_TABLE == self:
            HealthTable.FILTER_TABLE = None
            remove_filter(self.filter_name)

    def threshold_changed(self,val):
        self.table.clearSelection()
        self.matches.text='0'
        self.visible_objects = set()
        if not val and val!=0 :
            return
        matches=0
        for row in range(self.table.rowCount):
            item=self.table.item(row,2)
            table_val = item.data(QtCore.Qt.DisplayRole)
            if type(table_val)==int and table_val>=val:
                self.table.setRowHidden(row,True)
            else:
                self.table.setRowHidden(row,False)
                obj_id = int(self.table.item(row,0).text())
                self.visible_objects.add(obj_id)
                matches+=1
        self.matches.text=str(matches)
        if self.filterObjectsOnMap.visible and self.filterObjectsOnMap.checked:
            self.filter_on_map_on_off(False)
            self._update_filter_name(self.healthThreshold.value)
            self.filter_on_map_on_off(True)

    def save_all(self):
        from RoadCentre import project
        import gui

        fileName = QtGui.QFileDialog.getSaveFileName(gui.mainWindow,u"Сохранить файл",project.baseDir,u'csv files (*.csv)')
        if not fileName:
            return
        if QtCore.QFileInfo(fileName).suffix() == '':
            fileName += '.csv'
        f=QtCore.QFile(fileName)
        if not f.open(QtCore.QIODevice.WriteOnly):
            msgError(f.errorString())
            return
        f.write(u'Объект;Название;Детектор;Здоровье,%\r\n')
        for row in range(self.table.rowCount):
            if self.table.isRowHidden(row):
                continue
            f.write("%d;%s;%d;%f\r\n"%(self.getTableValue(row,0),self.getTableValue(row,3),self.getTableValue(row,1),self.getTableValue(row,2)))
        f.close()

    def tableSelectionChanged(self):
        from RoadCentre import project

        kernel.selectionModel.clearSelection()
        self.pkernel.selection_data=[]
        sel_dt=False
        sel_obj=False
        for item in self.table.selectedItems():
            if item.column()==0:
                obj_id=int(item.text())
                obj=project.object(obj_id)
                if obj:
                    obj.selected=True
                    self.pkernel.selection_data.append(obj)
                sel_obj=True
            elif item.column()==1 and (hasattr(plugins,'RoadNetworkPlugin') or hasattr(plugins,'Net329gPlugin')):
                sel_dt=True
                obj_id=int(self.table.item(item.row(),0).text())
                dt_id=int(item.text())
                if hasattr(plugins,'RoadNetworkPlugin'):
                    dt=plugins.RoadNetworkPlugin.findDetector(obj_id,dt_id)
                else:
                    dt = None
                if not dt:
                    key='%d-%d'%(obj_id,dt_id)
                    if key in self.NoNetworkDetectors:
                        self.pkernel.selection_data.append(self.NoNetworkDetectors[key])
                if dt:
                    dt.selected=True
                    self.pkernel.selection_data.append(dt)

    def tableCellDoubleClicked(self,row,column):
        if column==0:
            from actions import findController
            findController(self.getTableValue(row,column))
        if column==1:
            from actions import findDetector
            findDetector(self.getTableValue(row,0),self.getTableValue(row,column))

class NoNetworkDetector(QObject):
    def __init__(self,obj_id,dt_id):
        QObject.__init__(self)
        self.ownerId=obj_id
        self.id=dt_id
        self.selected=False
    def className(self): return 'DtHealth::NoNetworkDetector'
    def modelData(column,role):
        if role==0:
            return '%d:%d'%(ownerId,id)
        return None
    def inherits(self,classname):
        return classname==self.className() or classname=='Road::Graphics::DetectorItem'

class PseudoKernel:
    def __init__(self):
        self.selection_data=[]
    def selection(self):
        return self.selection_data

def showZoneDtHealthTable():
    if not hasattr(plugins,'RcdViewPlugin'):
        return
    zone=None
    for z in kernel.selection():
        if z.inherits('TSpider::Zone'):
            zone=z
            break
    if not zone:
        return
    table=HealthTable()
    table.objects=[]
    for area in zone.areas():
        table.objects+=list(area.objects())
    table.wndTitle=u'Здоровье детекторов для зоны %d(%s)'%(zone.id,zone.name)
    table.show()

def showAreaDtHealthTable():
    if not hasattr(plugins,'RcdViewPlugin'):
        return
    area=None
    for a in kernel.selection():
        if a.inherits('TSpider::Area'):
            area=a
            break
    if not area:
        return
    table=HealthTable()
    table.objects=list(area.objects())
    table.wndTitle=u'Здоровье детекторов для района %d(%s)'%(area.id,area.name)
    table.show()

def showRouteDtHealthTable():
    if not hasattr(plugins,'RcdViewPlugin'):
        return
    route=None
    for r in kernel.selection():
        if r.inherits('RouteGraphicsItem'):
            route=r
            break
    if not route:
        return
    table=HealthTable()
    table.objects=[]
    for l in route.lights():
        table.objects.append(l.id)
    table.wndTitle=u'Здоровье детекторов для маршрута %d(%s)'%(route.id,route.name)
    table.show()

def showObjectHealthTable():
    if not hasattr(plugins,'RcdViewPlugin'):
        return
    table=HealthTable()
    table.objects=[]
    obj_names=[]
    for o in kernel.selection():
        if o.inherits('Spectr::Light'):
            table.objects.append(o.id)
            obj_names.append(str(o.id))
    table.wndTitle=u'Здоровье детекторов для '
    if len(obj_names)>1:
        table.wndTitle+=u'объектов '+','.join(obj_names)
    else:
        table.wndTitle+=u'объектa '+obj_names[0]
    table.show()

def showDtHealthTable():
    if not hasattr(plugins,'RcdViewPlugin'):
        return
    HealthTable().show()

