﻿# -*- coding: utf-8 -*-
"""
Инициализация модуля "База данных"

(c)2013 ЗАО "РИПАС"
www.ripas.ru
"""
from RoadCentre import plugins
from gui import mainWindow, msgOk
from menu import Menu

if hasattr(plugins,'RcdViewPlugin'):
    pluginsMenu=mainWindow.findChild('QMenu','menuPlugins')
    if pluginsMenu is not None:
        from rcdview import editDbSettings, set_health_btn_state
        pluginsMenu.addAction(u'База данных').connect('triggered()',editDbSettings)
        
    from dthealth.dthealth import showDtHealthTable,showZoneDtHealthTable,showAreaDtHealthTable,showRouteDtHealthTable,showObjectHealthTable
    title=u'Здоровье ДТ'
    rcd_toolbar=mainWindow.addToolBar(u'База данных')
    rcd_toolbar.objectName='toolBarRcd'
    action=rcd_toolbar.addAction(title)
    action.objectName='dtHealth'
    action.enabled = False
    action.toolTip=u'Отобразить таблицу с показателем здоровя для каждого ДТ за последние 24 часа'
    action.connect('triggered()', showDtHealthTable)
    if hasattr(plugins,'TSpiderPlugin'):
        Menu.devClassMenus['TSpider::Zone'].appendCustomAction()
        Menu.devClassMenus['TSpider::Zone'].appendCustomAction(title,showZoneDtHealthTable)
        Menu.devClassMenus['TSpider::Area'].appendCustomAction()
        Menu.devClassMenus['TSpider::Area'].appendCustomAction(title,showAreaDtHealthTable)
    try:
        Menu.devClassMenus['RouteGraphicsItem'].appendCustomAction()
        Menu.devClassMenus['RouteGraphicsItem'].appendCustomAction(title,showRouteDtHealthTable)
    except: pass
    try:
        from rcdview import showPhases,showLog,showDt,showDtStat,showDtFaults,showDtHealthHistory,showSignalGroups
        m = Menu.devClassMenus['Spectr::Light'].appendCustomMenu('Исторические данные')
        a = m.addAction(u'Фазы')
        a.connect('triggered()', showPhases)
        a = m.addAction(u'Сигнальные группы')
        a.connect('triggered()', showSignalGroups)
        a = m.addAction(u'Журнал')
        a.connect('triggered()', showLog)
        a = m.addAction(u'Детекторы')
        a.connect('triggered()', showDt)
        a = m.addAction(u'Статистика детекторов')
        a.connect('triggered()', showDtStat)
        a = m.addAction(title)
        a.connect('triggered()', showObjectHealthTable)
        a = m.addAction(u'График отбраковки')
        a.connect('triggered()', showDtFaults)
        a = m.addAction(u'История здоровья')
        a.connect('triggered()', showDtHealthHistory)
    except: pass
    msgOk(u'Инициализации модулей "База данных" выполнена')
