# -*- coding: utf-8 -*-
"""
(c)2013-2020 ООО "РИПАС-СПБ"
www.ripas.ru
"""
from RoadCentre import kernel, plugins


def check_plugin():
    return hasattr(plugins, 'RcdViewPlugin')


def editDbSettings():
    if not check_plugin():
        return
    from RoadCentre import project
    new_url = plugins.RcdViewPlugin.editDbSettings()
    if len(new_url) > 0:
        project.settings.setValue('Plugins/RcdViewPlugin/db_url', new_url)
    del project


def selectedLights():
    if not check_plugin():
        return
    for dev in kernel.selection():
        if dev.inherits('Spectr::Light'):
            yield dev


def showPhases():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createPhasesWidget(dev.id)
        wnd.setWindowTitle(u'Диаграмма фаз для объекта ' + str(dev.id))
        wnd.show()

def showSignalGroups():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createSGWidget(dev.id)
        wnd.setWindowTitle(u'Диаграмма сигнальных групп для объекта ' + str(dev.id))
        wnd.show()

def showLog():
    from spectr import getDeviceVersion
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createLogWidget(dev.id, getDeviceVersion(dev))
        wnd.setWindowTitle(u'Архив журнала для объекта ' + str(dev.id))
        wnd.show()


def showDt():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createDtWidget(dev.id, ())
        wnd.show()


def showDtStat():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createDtStatWidget(dev.id, ())
        wnd.show()


def showDtFaults():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createDtFaultsView(dev.id)
        wnd.show()


def showDtHealthHistory():
    for dev in selectedLights():
        wnd = plugins.RcdViewPlugin.createDtHealthHistoryView(dev.id)
        wnd.show()


def set_health_btn_state(state):
    from gui import mainWindow
    rcd_toolbar = mainWindow.findChild('QToolBar', 'toolBarRcd')
    if rcd_toolbar:
        for act in rcd_toolbar.actions():
            act.enabled = state
