function Component()
{
	if (installer.isInstaller()){
		var product_id;
		if(systemInfo.currentCpuArchitecture.search("64") < 0) 
			product_id = "3E0A328FB4AB7A24B9524666CCB86BF4";
		else
			product_id = "7E184F6E03FE11847AC331972B9C5459";
		var tsvn_version = installer.execute("reg", new Array("QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\Installer\\Products\\"+product_id, "/v", "Version"))[0];
		if (tsvn_version){
			var elements = tsvn_version.split(" ");
			if (parseInt(elements[elements.length-1]) >= 0x10e7319) {
				component.setValue("Default",false);
				component.setValue("Description","Программа уже установлена");
				component.setValue("ForcedInstallation",false);
				component.enabled = false;
			}
		}
	}
}

Component.prototype.createOperations = function()
{
    // call default implementation to actually install the registeredfile
    component.createOperations();
	var instx86_file = installer.toNativeSeparators(installer.value("TargetDir")+"/TortoiseSVN-1.14.5.29465-win32-svn-1.14.2.msi");
	var instx64_file = installer.toNativeSeparators(installer.value("TargetDir")+"/TortoiseSVN-1.14.5.29465-x64-svn-1.14.2.msi");
	if (component.enabled) {
		if(systemInfo.currentCpuArchitecture.search("64") < 0) { //x86
			component.addOperation("Execute","msiexec","/i",instx86_file);
		} else {
			component.addOperation("Execute","msiexec","/i",instx64_file);
		}
	}
	if (installer.fileExists(instx86_file))
		component.addOperation("Delete",instx86_file);
	if (installer.fileExists(instx64_file))
		component.addOperation("Delete",instx64_file);
}
