# -*- coding: utf-8 -*-
"""
Закрытие проета:
Удаление загруженных зон камер

(c)2012 ЗАО "РИПАС" и Демин Федор,
www.ripas.ru dff@ripas.ru
"""

from RoadCentre import plugins


if hasattr(plugins, 'CamLayerPlugin'):
    from PythonQt.QtGui import QToolBar
    from settings import userSettings
    from gui import mainWindow
    if plugins.CamLayerPlugin.changed:
        from cams import saveCamList
        saveCamList()
        del saveCamList
    tb = mainWindow.findChild(QToolBar, 'toolBarCams')
    if tb is not None:
        userSettings.beginGroup('camsToolBarState')
        for a in tb.actions():
            d = a.data()
            if d:
                userSettings.setValue("type_%d" % d, '1' if a.checked else '0')
        userSettings.endGroup()
    plugins.CamLayerPlugin.clearCams()
    for cam in plugins.CamLayerPlugin.children():
        cam.deleteLater()
