# -*- coding: utf-8 -*-
"""
Открытие проета:
Загрузка камер

(c)2012 ЗАО "РИПАС" и Демин Федор,
www.ripas.ru dff@ripas.ru
"""
from RoadCentre import plugins
from gui import mainWindow


if hasattr(plugins, 'CamLayerPlugin'):
    from PythonQt.QtGui import QToolBar
    from cams import loadCamList
    from settings import userSettings
    loadCamList()
    del loadCamList
    # plugins.CamLayerPlugin.restoreGroupState()
    tb = mainWindow.findChild(QToolBar, 'toolBarCams')
    if tb is not None:
        tb_actions = tb.actions()
        tb = mainWindow.findChild(QToolBar, 'toolBarCams')
        if tb is not None:
            userSettings.beginGroup('camsToolBarState')
            for k in userSettings.childKeys():
                if not k.startswith("type_"):
                    continue
                try:
                    type = int(k[5:])
                    for a in tb_actions:
                        d = a.data()
                        if d and d == type:
                            a.checked = userSettings.value(k, '0') == '1'
                except ValueError:
                    pass
            userSettings.endGroup()
        for a in tb_actions:
            d = a.data()
            if d:
                plugins.CamLayerPlugin.setTypeVisible(d, a.checked)
