# -*- coding: utf-8 -*-
from math import pi,log,cos,tan,exp,atan
from PythonQt import QtCore
earthRadiusPolar = 6356863
degPerMeter = 180./(pi * earthRadiusPolar)

def long2tilex(lon,z):
    return ((lon + 180.0) / 360.0 * (1 << z))

def lat2tiley(lat,z):
    lat *= pi/180.0
    return ((.5 - log( tan(lat) + 1.0 / cos(lat)) / (pi * 2)) * (1 << z))

def tilex2long(x,z):
    return x  * 360.0/ (1 << z) - 180

def tiley2lat(y,z):
    n = pi - 2.0 * pi * y / (1 << z)
    return 180.0 / pi * atan(0.5 * (exp(n) - exp(-n)))

def geoToXY(pt):
    return QtCore.QPointF(long2tilex(pt.x(),12),lat2tiley(pt.y(),12))

def xyToGeo(pt):
    return QtCore.QPointF(tilex2long(pt.x(),12),tiley2lat(pt.y(),12))

def distanceFactor(latlon):
    p1=geoToXY(latlon)
    p2=xyToGeo(p1+QtCore.QPointF(0,1))
    delta_y=latlon.y()-p2.y()
    if delta_y==0.0:
        delta_y=1e-6

    return delta_y/degPerMeter

def distanceToMeter(dist,latlon):
    return dist*distanceFactor(latlon)

def MeterToDistance(meters,latlon):
    return meters/distanceFactor(latlon)
