
from PythonQt import QtCore, QtGui
import math
from priority.geometry import xyToGeo, geoToXY, MeterToDistance


class Granule(QtGui.QGraphicsItem):
    UNKNOWN = 0
    GREEN = 1
    RED = 2
    SCALE_ON_ZOOM = True
    PEN_SIZE = 1

    def __init__(self, parent, zoom, sg_data, pos):
        QtGui.QGraphicsItem.__init__(self, parent)
        self.sgData = {}
        self.bound = QtCore.QRectF()
        self.penSize = self.PEN_SIZE
        self.zoom = None
        self.disabled = False
        self.scale_on_zoom = self.SCALE_ON_ZOOM
        self.setPos(pos)
        self.changeGeometry(sg_data)
        self.zoomChanged(zoom)

    def changeGeometry(self, sg_data):
        self.prepareGeometryChange()
        self.bound = QtCore.QRectF()
        arrow_len = None
        for data in sg_data:
            connections = [self.UNKNOWN, [], []]
            for conn in data["connections"]:
                path = QtGui.QPainterPath()
                stop_path = QtGui.QPainterPath()
                for x, y in conn:
                    p2 = QtCore.QPointF(x,y)
                    if path.elementCount() == 0:
                        path.moveTo(p2)
                    else:
                        path.lineTo(p2)
                element_count = path.elementCount()
                if element_count > 1:
                    if arrow_len is None:
                        arrow_len = MeterToDistance(3, path.elementAt(0).operator_cast_QPointF())
                        dy = arrow_len / 3.0
                    p1 = geoToXY(path.elementAt(0).operator_cast_QPointF())
                    p2 = geoToXY(path.elementAt(1).operator_cast_QPointF())
                    direction = QtCore.QLineF(p1, p2)
                    direction.setLength(arrow_len*3)
                    p2 = direction.p2()
                    dp = p1 - p2
                    direction.translate(dp.x(), dp.y())
                    p1 = direction.p1()
                    p2 = direction.p2()
                    t = QtGui.QTransform()
                    t.translate(p2.x(), p2.y())
                    t.rotate(-direction.angle())
                    stop_path.moveTo(xyToGeo(p1))
                    stop_path.lineTo(xyToGeo(p2))
                    stop_path.lineTo(xyToGeo(t.map(QtCore.QPointF(-arrow_len, -dy))))
                    stop_path.moveTo(xyToGeo(p2))
                    stop_path.lineTo(xyToGeo(t.map(QtCore.QPointF(-arrow_len, dy))))
                    connections[2].append(stop_path)

                    if element_count > 3:
                        p1 = geoToXY(path.elementAt(element_count-4).operator_cast_QPointF())
                    else:
                        p1 = geoToXY(path.elementAt(element_count-2).operator_cast_QPointF())
                    p2 = geoToXY(path.elementAt(element_count-1).operator_cast_QPointF())
                    direction = QtCore.QLineF(p1, p2)
                    t = QtGui.QTransform()
                    t.translate(p2.x(), p2.y())
                    t.rotate(-direction.angle())
                    path.moveTo(xyToGeo(p1))
                    path.lineTo(xyToGeo(p2))
                    path.lineTo(xyToGeo(t.map(QtCore.QPointF(-arrow_len, -dy))))
                    path.moveTo(xyToGeo(p2))
                    path.lineTo(xyToGeo(t.map(QtCore.QPointF(-arrow_len, dy))))

                connections[1].append(path)
                self.bound = self.bound.united(path.boundingRect())
                self.bound = self.bound.united(stop_path.boundingRect())
            self.sgData[data["tl_id"]] = connections
        pt_pos = self.pos()
        for sg_id, connections in self.sgData.items():
            for conn in connections[1]:
                conn.translate(QtCore.QPointF() - pt_pos)
            for conn in connections[2]:
                conn.translate(QtCore.QPointF() - pt_pos)
        self.bound.translate(QtCore.QPointF() - pt_pos)

    def zoomChanged(self, zoom):
        if zoom <= 15:
            zoom = 15
        if self.zoom == zoom:
            return
        self.zoom = zoom
        if self.scale_on_zoom:
            self.setScale(12145 * math.exp(-0.55 * self.zoom))
        # print "zoom=%d k=%f"%(zoom, 12145 * math.exp(-0.55 * self.zoom))
        # self.prepareGeometryChange()

    def boundingRect(self):
        return self.bound

    def setSgState(self, id, state):
        if self.disabled:
            return
        for sg_id, connections in self.sgData.items():
            if sg_id == id:
                connections[0] = state
        self.update()

    def resetStates(self, disable_granule = False):
        for sg_id, connections in self.sgData.items():
            connections[0] = self.UNKNOWN
        self.disabled = disable_granule
        self.update()

    def paint(self, painter, opt, w):
        pen = painter.pen()
        if not pen.isCosmetic():
            pen.setCosmetic(True)
        pen.setWidthF(self.penSize)
        for sg_id, connections in self.sgData.items():
            sg_state = connections[0]
            path_index = 1
            if sg_state == self.GREEN:
                pen.setColor(QtCore.Qt.darkGreen)
            elif sg_state == self.RED:
                pen.setColor(QtCore.Qt.red)
                path_index = 2
            else:
                continue
            painter.setPen(pen)
            for conn in connections[path_index]:
                painter.drawPath(conn)
