﻿# -*- coding: utf-8 -*-
"""
Инициализация модуля "Сервис"

(c)2013-2020 ООО "РИПАС-СПБ"
www.ripas.ru
"""
from RoadCentre import plugins

if hasattr(plugins, 'Service') and hasattr(plugins, 'RcdViewPlugin'):
    from service import metarpcObjectConnected, jsonrpcObjectConnected, createDtSetupWidget
    if hasattr(plugins, 'MetaRpcPlugin'):
        plugins.MetaRpcPlugin.connect('rpcObjectConnected(QObject*)', metarpcObjectConnected)
    if hasattr(plugins, 'JsonRpcClientPlugin'):
        plugins.JsonRpcClientPlugin.connect('rpcObjectConnected(QString)', jsonrpcObjectConnected)
    title = u'Настройка отбраковки'
    from menu import Menu
    if hasattr(plugins, 'RoadNetworkPlugin'):
        dt_menu = Menu.devClassMenus['Road::Graphics::DetectorItem']
        if dt_menu:
            dt_menu.appendCustomAction()
            dt_menu.appendCustomAction(title, createDtSetupWidget)
    tl_menu = Menu.devClassMenus['Spectr::Light']
    if tl_menu:
        tl_menu.appendSubmenuAction('Исторические данные', title, createDtSetupWidget)
