# -*- coding: utf-8 -*-

from PythonQt import QtGui
from RoadCentre import kernel, plugins


def createDtSetupWidget():
    from gui import mainWindow
    if not hasattr(createDtSetupWidget, 'rcd_rpc'):
        QtGui.QMessageBox.warning(mainWindow, u'Внимание!', u'rpc объект ещё не подключен')
        return
    sel_list = createDtSetupWidget.sender.selection
    if sel_list is None or len(sel_list) == 0:
        sel_list = kernel.graphicsScene.selectedItems()
    for sel in sel_list:
        dt_id = None
        tl_id = None
        if sel.inherits('QGraphicsItem'):
            net329 = getattr(plugins,'Net329gPlugin',None)
            if net329:
                dt = net329.item2object(sel)
                if dt.inherits('Detector'):
                    granule = dt.granule
                    if granule and granule.tlId > 0:
                        tl_id = granule.tlId
                        dt_id = dt.tlId
        elif sel.inherits('Spectr::Light'):
            tl_id = sel.id
        else:
            tl_id = sel.ownerId
        if dt_id is not None or sel.inherits('Road::Graphics::DetectorItem'):
            if dt_id is None:
                dt_id = sel.id
            w = plugins.Service.createDtSetupWidget(tl_id, dt_id, plugins.RcdViewPlugin.database(), createDtSetupWidget.rcd_rpc)
            w.windowTitle = u'Настройка отбраковки для дт %d-%d' % (tl_id, dt_id)
            w.show()
        elif sel.inherits('Spectr::Light'):
            w = plugins.Service.createDtSetupWidget(sel.id, plugins.RcdViewPlugin.database(), createDtSetupWidget.rcd_rpc)
            w.windowTitle = u'Настройка отбраковки для %d' % sel.id
            w.show()


def metarpcObjectConnected(rpc_obj):
    if not rpc_obj.objectName == 'rcdService':
        return
    createDtSetupWidget.rcd_rpc = rpc_obj


def jsonrpcObjectConnected(rpc_obj_name):
    if rpc_obj_name != 'rcd':
        return
    if hasattr(plugins, 'JsonRpcClientPlugin'):
        createDtSetupWidget.rcd_rpc = plugins.JsonRpcClientPlugin


def objectConsole():
    from gui import mainWindow
    for light in kernel.selection():
        if not light.inherits("Spectr::Light"):
            continue
        if not hasattr(light, 'console'):
            obj_console = plugins.Service.createObjectConsole(light)
            if not obj_console:
                continue
            if not mainWindow.restoreDockWidget(obj_console):
                obj_console.floating = True
            obj_console.show()
            getattr(obj_console, 'raise')()
            obj_console.connect('destroyed(QObject*)', objectConsoleDestroyed)
            obj_console.setProperty('monitoredObject', light)
            light.setProperty('console', obj_console.output)
    del mainWindow


def objectConsoleDestroyed(obj):
    if hasattr(obj, 'monitoredObject'):
        obj.monitoredObject.setProperty('console', None)
